package gov.va.med.mhv.mrp.enums;

public enum GoalTaskRepetitionCycleTypeEnum {
	
	NOREPEAT(1, "Does Not Repeat"), DAILY(3, "Daily"), MWF(4, "Every Monday Wednesday Friday"), 
	TT(5, "Every Tuesday Thursday"), WEEKDAY(6, "Every Weekday"),
	WEEKLY(7, "Weekly"), OTHERWEEK(8, "Every Other Week"), MONTHLY(9, "Monthly"), YEARLY(10, "Yearly");
	
	private Integer code;
	private String description;
	
	private GoalTaskRepetitionCycleTypeEnum(Integer code, String description) {
		this.code = code;
		this.description = description;
	}

	public static GoalTaskRepetitionCycleTypeEnum findByCode(Integer code) {
		for (GoalTaskRepetitionCycleTypeEnum e : GoalTaskRepetitionCycleTypeEnum.values()) {
			if (e.code == code) {
				return e;
			}
		}
		// could be bad data
		return GoalTaskRepetitionCycleTypeEnum.NOREPEAT;
	}

	public Integer getCode() {
		return code;
	}

	public String getDescription() {
		return description;
	}
}
